/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.api.IEditableMemory;
import frc.emul.api.IMemory;
import frc.emul.api.IVectrexMemory;
import frc.emul.api.MemoryAccessException;
import frc.emul.api.MemoryNotAvailableException;
import frc.emul.api.MemoryType;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.data.DevOptions;
import frc.emul.util.BankMemory;
import frc.emul.util.MultipleMemory;
import frc.emul.util.NullMemory;
import frc.emul.util.RawMemory;
import frc.emul.util.ShadowMemory;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.Via6522Mapping;
import frc.emul.via6522.Via6522;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class VectrexMemory
implements IMemory,
IVectrexMemory {
    public static final int VECFLASH_LOW_PULSE_MAX_CYCLES = 80;
    public static final boolean DBG_BANKSWITCH = false;
    public static final int MAX_MEMORY_BANKS = 64;
    public static final boolean HANDLE_MEMORY_BANKS = true;
    public static final boolean REPORT_FAULTY_WRITES = false;
    public static final boolean MAP_EMPTY_MEMORY = true;
    public static long RAM_RANDOM_SEED = -889275714L;
    private VECFLASH vfState;
    private int oldPB6;
    private long timePB6;
    private boolean cartridgeLoaded;
    private boolean cartridgeBankable;
    private boolean vecflashMode;
    private final IMemory[] MAPPING = new IMemory[256];
    private final NullMemory NULL = new NullMemory(0, 65536, false, 0);
    private final Via6522Mapping VIA;
    private final MultipleMemory MUX_RAMVIA;
    private final BankMemory CARTRIDGE = new BankMemory(MemoryType.CARTRIDGE, 0, 32768, false, true, false, true, 64);
    private RawMemory CART_RAM;
    private final RawMemory RAM = new RawMemory(MemoryType.RAM, 51200, 1024, false, true, true, true);
    private final RawMemory ROM = new RawMemory(MemoryType.ROM, 57344, 8192, false, true, false, true);

    public VectrexMemory() {
        this.VIA = new Via6522Mapping(53248, 2048);
        this.MUX_RAMVIA = new MultipleMemory(55296, 2048, new IMemory[]{this.RAM, this.VIA});
        this.NULL.setInstalledEmulatorTag(true);
        this.install(this.NULL, 1);
        this.install(this.CARTRIDGE, 1);
        this.install(this.RAM, 2);
        this.install(this.VIA, 1);
        this.install(this.MUX_RAMVIA, 1);
        this.install(this.ROM, 1);
        VectrexMemory.randomize(this.RAM, RAM_RANDOM_SEED);
        this.removeCartridge();
        this.resetBankSwitching();
    }

    public void setVIA6522(Via6522 via6522) {
        this.VIA.setVIA6522(via6522);
    }

    public void setFatalAccessToInexistentMemory(boolean bl) {
        this.NULL.setFatalReadAccess(bl);
        this.NULL.setFatalWriteAccess(bl);
    }

    public boolean isFatalAccessToInexistentMemory() {
        return this.NULL.isFatalWriteAccess() && this.NULL.isFatalReadAccess();
    }

    public boolean loadROM(InputStream inputStream) throws IOException {
        try {
            boolean bl = this.ROM.load(inputStream, true);
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public boolean loadCartridge(InputStream inputStream) throws IOException {
        this.removeCartridge();
        try {
            this.cartridgeLoaded = this.CARTRIDGE.load(inputStream, true);
            if (this.cartridgeLoaded) {
                int n = this.CARTRIDGE.getLoadedBanksCount();
                switch (n) {
                    case 0: 
                    case 1: {
                        boolean bl;
                        this.cartridgeBankable = false;
                        this.setSelectedCartBank(0);
                        this.setVecflashMode(false);
                        boolean bl2 = bl = n != 0 && this.isVecmultiWriteEnabled();
                        if (bl || DevOptions.automaticCartridgeRAM) {
                            this.installAutomaticCartridgeRAM();
                        }
                        this.setCartridgeWriteMode(bl);
                        break;
                    }
                    case 2: {
                        boolean bl = this.cartridgeBankable = this.CARTRIDGE.isValidCartridgeHeader(1);
                        if (this.cartridgeBankable) {
                            System.out.println("-> Switching to dual banks cartridge mode");
                        } else {
                            System.out.println("*** Code beyond 64K does not have a valid cartridge header, discarding it...");
                        }
                        this.setSelectedCartBank(this.cartridgeBankable ? 1 : 0);
                        this.setVecflashMode(false);
                        this.setCartridgeWriteMode(this.isVecmultiWriteEnabled());
                        break;
                    }
                    default: {
                        this.cartridgeBankable = true;
                        System.out.println("-> Switching to VecFlash cartridge mode");
                        int n2 = 0;
                        while (n2 < n) {
                            System.out.println(" > Bank #" + n2 + (this.CARTRIDGE.isValidCartridgeHeader(n2) ? " has a valid cartridge header" : " has an INVALID cartridge header!!!"));
                            ++n2;
                        }
                        this.setSelectedCartBank(0);
                        this.setVecflashMode(true);
                        this.setCartridgeWriteMode(this.isVecmultiWriteEnabled());
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return this.cartridgeLoaded;
    }

    public void removeCartridge() {
        this.cartridgeLoaded = false;
        this.cartridgeBankable = false;
        this.CARTRIDGE.fill((byte)1);
        this.CARTRIDGE.setSelectedBank(0);
    }

    public int installAutomaticCartridgeRAM() {
        int n;
        int n2;
        int n3 = this.CARTRIDGE.getLastAddress();
        int n4 = n3 - (n2 = ((n = this.CARTRIDGE.getLoadedBankSize(0)) & 0xFF00) + ((n & 0xFF) + 255 & 0x100)) + 1;
        if (n4 <= 0) {
            return 0;
        }
        String string = (n4 & 0x3FF) == 0 ? String.valueOf(Integer.toString(n4 / 1024)) + "Kb" : String.valueOf(Integer.toString(n4)) + " bytes";
        System.out.println("-> Mapping " + string + " of on-board RAM in area $" + Utils.hex4(n2) + "-$" + Utils.hex4(n3));
        this.installCartridgeRAM(n2, n4);
        return n4;
    }

    public void installCartridgeRAM(int n, int n2) {
        this.removeCartridgeRAM();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Cartridge RAM size must be greater than 0");
        }
        if ((n & 0xFF) != 0 || (n2 & 0xFF) != 0) {
            throw new IllegalArgumentException("Cartridge RAM address & size must be multiples of 256");
        }
        RawMemory rawMemory = new RawMemory(MemoryType.CART_RAM, n, n2, false, true, true, true);
        if (rawMemory.getFirstAddress() < this.CARTRIDGE.getFirstAddress() || rawMemory.getLastAddress() > this.CARTRIDGE.getLastAddress()) {
            throw new IllegalArgumentException("The cartridge RAM lies outside of the cartridge address space!");
        }
        this.CART_RAM = rawMemory;
        this.CART_RAM.fill((byte)0);
        this.install(this.CART_RAM, 1);
    }

    public void removeCartridgeRAM() {
        if (this.hasCartridgeRAM()) {
            this.CART_RAM = null;
            this.install(this.CARTRIDGE, 1);
        }
    }

    public final int getSelectedCartBank() {
        return this.CARTRIDGE.getSelectedBank();
    }

    public final void setSelectedCartBank(int n) {
        if (n != this.CARTRIDGE.getSelectedBank()) {
            this.CARTRIDGE.setSelectedBank(n);
        }
    }

    public final int selectBank(int n) {
        if (this.isCartridgeBankable()) {
            if (!this.isVecflashMode()) {
                n &= 1;
            }
        } else {
            n = 0;
        }
        this.CARTRIDGE.setSelectedBank(n);
        return n;
    }

    public final int selectNextVecFlashBank() {
        int n = this.CARTRIDGE.getSelectedBank();
        if (this.isVecflashMode()) {
            this.CARTRIDGE.setSelectedBank(++n);
        }
        return n;
    }

    public final boolean isCartridgeLoaded() {
        return this.cartridgeLoaded;
    }

    public final boolean isCartridgeBankable() {
        return this.cartridgeBankable;
    }

    public final boolean isVecflashMode() {
        return this.vecflashMode;
    }

    public final boolean hasCartridgeRAM() {
        return this.CART_RAM != null;
    }

    public final boolean isAvailable(MemoryType memoryType) {
        switch (memoryType) {
            case CARTRIDGE: {
                return this.isCartridgeLoaded();
            }
            case CART_RAM: {
                return this.hasCartridgeRAM();
            }
            case ROM: 
            case RAM: 
            case VIA6522: {
                return true;
            }
        }
        return false;
    }

    public final IMemory getMemory(MemoryType memoryType) {
        switch (memoryType) {
            case CARTRIDGE: {
                return this.CARTRIDGE;
            }
            case CART_RAM: {
                return this.CART_RAM;
            }
            case RAM: {
                return this.RAM;
            }
            case ROM: {
                return this.ROM;
            }
            case VIA6522: {
                return this.VIA;
            }
        }
        return null;
    }

    public final IMemory getMemory(int n) {
        IMemory iMemory = this.map(n);
        return this.isAvailable(iMemory.getType()) ? iMemory : null;
    }

    public final MemoryType getMemoryType(int n) {
        return this.map(n).getType();
    }

    public MemoryType getType() {
        return MemoryType.OTHER;
    }

    public int readS8(int n) {
        try {
            return this.map(n).readS8(n);
        }
        catch (Exception exception) {
            return this.readError(n, exception, true, true);
        }
    }

    public int readU8(int n) {
        try {
            return this.map(n).readU8(n);
        }
        catch (Exception exception) {
            return this.readError(n, exception, true, false);
        }
    }

    public void write8(int n, int n2) {
        try {
            this.map(n).write8(n, n2);
        }
        catch (Exception exception) {
            this.writeError(n, exception, true, n2);
        }
    }

    public int readS16(int n) {
        try {
            return this.map(n).readS16(n);
        }
        catch (Exception exception) {
            return this.readError(n, exception, false, true);
        }
    }

    public int readU16(int n) {
        try {
            return this.map(n).readU16(n);
        }
        catch (Exception exception) {
            return this.readError(n, exception, false, false);
        }
    }

    public void write16(int n, int n2) {
        try {
            this.map(n).write16(n, n2);
        }
        catch (Exception exception) {
            this.writeError(n, exception, false, n2);
        }
    }

    public int getLoadedSize() {
        return this.getSize();
    }

    public int getSize() {
        return 65535;
    }

    public int getFirstAddress() {
        return 0;
    }

    public int getLastAddress() {
        return 65535;
    }

    public void fill(byte by) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidArea(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean canExecute(int n, int n2) {
        IMemory iMemory = this.map(n);
        return iMemory != null && iMemory.canExecute(n, n2);
    }

    public boolean canRead(int n, int n2) {
        IMemory iMemory = this.map(n);
        if (iMemory == null) {
            return false;
        }
        if (this.VIA == iMemory || this.MUX_RAMVIA == iMemory) {
            return false;
        }
        return iMemory.canRead(n, n2);
    }

    public boolean dump(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public boolean save(OutputStream outputStream, boolean bl) throws IOException {
        return this.CARTRIDGE.save(outputStream, bl) && this.RAM.save(outputStream, bl) && this.ROM.save(outputStream, bl);
    }

    public boolean load(InputStream inputStream, boolean bl) throws IOException {
        return this.CARTRIDGE.load(inputStream, bl) && this.RAM.load(inputStream, bl) && this.ROM.load(inputStream, bl);
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        this.store(iPersistenceWriter, false, false);
    }

    public void store(IPersistenceWriter iPersistenceWriter, boolean bl, boolean bl2) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.MEMORY);
        iPersistenceWriter.openSection(PersistentSection.MEM_RAM);
        this.RAM.store(iPersistenceWriter);
        iPersistenceWriter.closeSection();
        iPersistenceWriter.openSection(PersistentSection.MEM_CARTRAM);
        iPersistenceWriter.write(this.hasCartridgeRAM());
        if (this.hasCartridgeRAM()) {
            iPersistenceWriter.write16(this.CART_RAM.getFirstAddress());
            iPersistenceWriter.write16(this.CART_RAM.getSize());
            this.CART_RAM.store(iPersistenceWriter);
        }
        iPersistenceWriter.closeSection();
        iPersistenceWriter.openSection(PersistentSection.MEM_ROM);
        iPersistenceWriter.write(bl);
        if (bl) {
            this.ROM.store(iPersistenceWriter);
        }
        iPersistenceWriter.closeSection();
        iPersistenceWriter.openSection(PersistentSection.MEM_CARTRIDGE);
        iPersistenceWriter.write(bl2 && this.isCartridgeLoaded());
        if (bl2 && this.isCartridgeLoaded()) {
            this.CARTRIDGE.store(iPersistenceWriter);
        }
        iPersistenceWriter.closeSection();
        iPersistenceWriter.openSection(PersistentSection.MEM_BANK_SWITCH);
        iPersistenceWriter.write8(this.vfState.ordinal());
        iPersistenceWriter.write8(this.oldPB6);
        iPersistenceWriter.write(this.timePB6);
        iPersistenceWriter.write16(this.getSelectedCartBank());
        iPersistenceWriter.closeSection();
        iPersistenceWriter.closeSection();
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.load(iPersistenceReader, true, true);
    }

    public void load(IPersistenceReader iPersistenceReader, boolean bl, boolean bl2) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.MEMORY);
        this.loadSection(iPersistenceReader, bl, bl2);
        iPersistenceReader.closeSection();
    }

    public void loadSection(IPersistenceReader iPersistenceReader, boolean bl, boolean bl2) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.MEM_RAM);
        this.RAM.load(iPersistenceReader);
        iPersistenceReader.closeSection();
        iPersistenceReader.openSection(PersistentSection.MEM_CARTRAM);
        if (iPersistenceReader.readBool()) {
            int n = iPersistenceReader.readU16();
            int n2 = iPersistenceReader.readU16();
            this.installCartridgeRAM(n, n2);
            this.CART_RAM.load(iPersistenceReader);
        } else {
            this.removeCartridgeRAM();
        }
        iPersistenceReader.closeSection();
        iPersistenceReader.openSection(PersistentSection.MEM_ROM);
        if (iPersistenceReader.readBool() && !bl) {
            this.ROM.load(iPersistenceReader);
        }
        iPersistenceReader.closeSection();
        iPersistenceReader.openSection(PersistentSection.MEM_CARTRIDGE);
        if (iPersistenceReader.readBool() && !bl2) {
            this.removeCartridge();
            this.CARTRIDGE.load(iPersistenceReader);
            this.cartridgeLoaded = true;
        }
        iPersistenceReader.closeSection();
        if (iPersistenceReader.getSaveVersion() > 100308) {
            iPersistenceReader.openSection(PersistentSection.MEM_BANK_SWITCH);
            if (this.isCartridgeBankable()) {
                this.vfState = VECFLASH.values()[iPersistenceReader.readU8()];
                this.oldPB6 = iPersistenceReader.readU8();
                this.timePB6 = iPersistenceReader.readLong();
                this.setSelectedCartBank(iPersistenceReader.readU16());
            }
            iPersistenceReader.closeSection();
        }
    }

    private void install(IMemory iMemory, int n) {
        IMemory iMemory2 = iMemory;
        int n2 = iMemory.getFirstAddress();
        int n3 = iMemory.getSize();
        int n4 = n2 >> 8;
        int n5 = n3 + 254 >> 8;
        while (n-- > 0) {
            int n6 = n5;
            while (n6-- > 0) {
                this.MAPPING[n4 + n6] = iMemory2;
            }
            if (n <= 0) continue;
            n4 += n5;
            iMemory2 = new ShadowMemory(iMemory, n2 += n3);
        }
    }

    private boolean isVecmultiWriteEnabled() {
        try {
            return this.readU8(6) == 83 && this.readU8(7) == 82 && this.readU8(8) == 65 && this.readU8(9) == 77;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setCartridgeWriteMode(boolean bl) {
        if (bl) {
            System.out.println("-> Tagging cartridge area as writable (VecMulti SRAM mode)");
        }
        this.CARTRIDGE.setWritable(bl);
    }

    private void setVecflashMode(boolean bl) {
        this.vecflashMode = bl;
    }

    private IMemory map(int n) {
        return this.MAPPING[n >> 8 & 0xFF];
    }

    private void checkInvalidAccess(int n, Exception exception, boolean bl, String string) {
        if (exception instanceof NullPointerException && this.map(n) == null) {
            String string2 = bl ? "byte" : "word";
            throw new MemoryNotAvailableException("Invalid address for " + string + " access on " + string2 + " at $" + Utils.hex(4, n));
        }
    }

    private int readError(int n, Exception exception, boolean bl, boolean bl2) {
        IMemory iMemory;
        IMemory iMemory2;
        this.checkInvalidAccess(n, exception, bl, "read");
        if (!bl && (iMemory2 = this.map(n)) != (iMemory = this.map(n + 1))) {
            try {
                return (bl2 ? iMemory2.readS8(n) : iMemory2.readU8(n)) << 8 | iMemory.readU8(n + 1 & 0xFFFF);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new MemoryAccessException(n, exception, bl);
    }

    private void writeError(int n, Exception exception, boolean bl, int n2) {
        IMemory iMemory;
        IMemory iMemory2;
        this.checkInvalidAccess(n, exception, bl, "write");
        if (!bl && (iMemory2 = this.map(n)) != (iMemory = this.map(n + 1))) {
            try {
                iMemory2.write8(n, n2 >> 8);
                iMemory.write8(n + 1 & 0xFFFF, n2);
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new MemoryAccessException(n, (Throwable)exception, bl, n2);
    }

    public static final void randomize(IEditableMemory iEditableMemory, int n, int n2, long l) {
        if (0L != l) {
            byte[] byArray = new byte[n2];
            new Random(l).nextBytes(byArray);
            iEditableMemory.poke(byArray, 0, n, n2);
        }
    }

    public static final void randomize(IMemory iMemory, long l) {
        if (0L != l) {
            int n = iMemory.getSize();
            byte[] byArray = new byte[n];
            new Random(l).nextBytes(byArray);
            iMemory.feed(byArray, 0, iMemory.getFirstAddress(), n);
        }
    }

    public static final boolean isValidCartridgeHeader(byte[] byArray) {
        try {
            return byArray.length > 16 && byArray[0] == 103 && byArray[1] == 32 && byArray[2] == 71 && byArray[3] == 67 && byArray[4] == 69 && byArray[5] == 32;
        }
        catch (Exception exception) {
            return false;
        }
    }

    final void resetBankSwitching() {
        this.vfState = VECFLASH.RESET;
        this.oldPB6 = -1;
        this.timePB6 = 0L;
        if (this.isCartridgeBankable()) {
            this.setSelectedCartBank(this.isVecflashMode() ? 0 : 1);
        }
    }

    final void handleChanged6522PortB(int n, long l) {
        int n2 = n & 0x40;
        if (this.oldPB6 != n2) {
            this.oldPB6 = n2;
            if (!this.isVecflashMode()) {
                this.setSelectedCartBank(n2 == 0 ? 0 : 1);
                return;
            }
            while (true) {
                switch (this.vfState) {
                    case RESET: {
                        this.selectBank(0);
                        this.vfState = VECFLASH.LOW_CHECK;
                        break;
                    }
                    case LOW_CHECK: {
                        if (n2 == 0) {
                            this.selectNextVecFlashBank();
                            this.vfState = VECFLASH.LOW_PULSE;
                            this.timePB6 = l;
                        }
                        return;
                    }
                    case LOW_PULSE: {
                        if (n2 == 0) {
                            this.vfState = VECFLASH.LOW_PULSE;
                            break;
                        }
                        long l2 = l - this.timePB6;
                        if (l2 < 80L) {
                            this.vfState = VECFLASH.LOW_CHECK;
                            return;
                        }
                        this.vfState = VECFLASH.RESET;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VECFLASH {
        RESET,
        LOW_CHECK,
        LOW_PULSE;

    }
}

